-- MOD per DCS WORLD 
-- Corazzata Tedesca WWII Bismark  by Markindel and Cadarth
-- German Ship WWII Bismark
-----             Cartella Shapes --------------------------------------------------
mount_vfs_model_path	(current_mod_path.."/Shapes/")

-----             Cartella Textures ---------------------------------------------------
mount_vfs_texture_path  (current_mod_path.."/Textures/")
mount_vfs_texture_path  (current_mod_path.."/Textures/Textures_Hipper.zip")

-----             Cartella Sound --------------------------------------------------
--mount_vfs_model_path	(current_mod_path.."/Sound/")
--mount_vfs_model_path	(current_mod_path.."/Sound/Effects")
--mount_vfs_model_path	(current_mod_path.."/Sound/Effects/Weapons")


GT = {};
GT_t.ws = 0;

set_recursive_metatable(GT, GT_t.generic_ship)

GT.visual = {}
GT.visual.shape = "DKM_Blucher"
GT.visual.shape_dstr = ""

---------------------------------------------------------------------
----------------------------------------------------------------------

GT.animation_arguments.radar1_rotation = 11; --   1
GT.radar1_period = 3;
GT.animation_arguments.radar2_rotation = -1; --   2 
GT.animation_arguments.radar3_rotation = -1; --   3 
GT.animation_arguments.luna_lights = -1;


GT.life = 6500
GT.mass = 7.25e+006
GT.max_velocity = 55,6
GT.race_velocity = 40
GT.economy_velocity = 30
GT.economy_distance = 1.59272e+007
GT.race_distance = 1.59272e+007
GT.shipLength = 234
GT.Width = 30
GT.Height = 25.6
GT.Length = 234
GT.DeckLevel = 9.9

GT.X_nose = 121.5000
GT.X_tail = -123.000

GT.Tail_Width = 11
GT.Gamma_max = 0.35
GT.Om = 0.05
GT.speedup = 0.1
GT.R_min = 212.4
GT.distFindObstacles = 368.6

GT.airWeaponDist = 10000  --- edited by baco30 was 100000
GT.airFindDist = 20000    --- was 150000

---- Primo valore    : avanti/indietro
---- Secondo valore: alto/basso
---- Terzo Valore    : destra/sinistra

GT.exhaust = 
{
	[1] = { size = 0.90 , pos = {10.41 , 24.472, 0.0 } },
}



GT.DM = {
----- Scafo.
    { area_name = "Scafo_Prua_Dx",			area_arg = 76,	area_life = 100, area_fire = { pos = {93.0, 4.0, 8.0}, size = 1.5}},  
    { area_name = "Scafo_Prua_Sx", 		    area_arg = 73,	area_life = 100, area_fire = { pos = {50.0, 4.0, -5.0}, size = 1.5}},  
	{ area_name = "Zona_Fumaiolo",          area_arg = 77,	area_life = 60,  area_fire = { pos = {0.5, 12.0, 0.0}, size = 2.5}},   
	{ area_name = "Ponte_Poppa",	        area_arg = 78,	area_life = 80,  area_fire = { pos = {-44.0, 9.6, 0.0}, size = 0.5}},  
	{ area_name = "Sala_Comando",	        area_arg = 83,	area_life = 150, area_fire = { pos = {15.0, 12.0, 0.0}, size = 2.5}}, 

}


-- Source for modifications: https://en.wikipedia.org/wiki/Littorio-class_battleship
-- https://en.wikipedia.org/wiki/Italian_battleship_Roma_%281940%29
-- ship_Breda_20/65 (20 mm) naval AAA weapons. Source: https://en.wikipedia.org/wiki/Breda_Model_35
-- Used default Mark 15 CIWS Phalanx Block 1 weapon system as template with alterations
GT_t.WS_t.ship_Breda_20_65 = {name = "2 cm Breda /65"};
GT_t.WS_t.ship_Breda_20_65.angles = {
                    {math.rad(180), math.rad(-180), math.rad(-10), math.rad(90)},
                    };
GT_t.WS_t.ship_Breda_20_65.omegaY = math.rad(115) -- Block 1B
GT_t.WS_t.ship_Breda_20_65.omegaZ = math.rad(116) -- Block 1B
GT_t.WS_t.ship_Breda_20_65.pidY = {p=300, i = 0.05, d = 10.0, inn = 1000};
GT_t.WS_t.ship_Breda_20_65.pidZ = {p=300, i = 0.05, d = 10.0, inn = 1000};
GT_t.WS_t.ship_Breda_20_65.reference_angle_Z = 0
GT_t.WS_t.ship_Breda_20_65.LN = {}
GT_t.WS_t.ship_Breda_20_65.LN[1] = {}
GT_t.WS_t.ship_Breda_20_65.LN[1].type = 3
GT_t.WS_t.ship_Breda_20_65.LN[1].distanceMin = 10
GT_t.WS_t.ship_Breda_20_65.LN[1].distanceMax = 1500 -- effective shooting with 3600 meters
GT_t.WS_t.ship_Breda_20_65.LN[1].max_trg_alt = 1000
GT_t.WS_t.ship_Breda_20_65.LN[1].reactionTime = 1.8
GT_t.WS_t.ship_Breda_20_65.LN[1].beamWidth = math.rad(1);
GT_t.WS_t.ship_Breda_20_65.LN[1].sensor = {}
set_recursive_metatable(GT_t.WS_t.ship_Breda_20_65.LN[1].sensor, GT_t.WSN_t[3])
GT_t.WS_t.ship_Breda_20_65.LN[1].PL = {}
GT_t.WS_t.ship_Breda_20_65.LN[1].PL[1] = {}
GT_t.WS_t.ship_Breda_20_65.LN[1].PL[1].ammo_capacity = 1550;
GT_t.WS_t.ship_Breda_20_65.LN[1].PL[1].shell_name = {"Rh202_20_AP", "Rh202_20_HE"};
GT_t.WS_t.ship_Breda_20_65.LN[1].PL[1].shell_display_name = "20mm AP+HE";
GT_t.WS_t.ship_Breda_20_65.LN[1].PL[1].shot_delay = 60/240 -- 240 rounds per minute average
GT_t.WS_t.ship_Breda_20_65.LN[1].PL[1].reload_time = 1000000; -- never during the mission (ship autogun)
GT_t.WS_t.ship_Breda_20_65.LN[1].BR = { {pos = {3.478, 0, 0} }, }

-- Source for modifications: https://en.wikipedia.org/wiki/German_battleship_Bismarck
-- ship_FlaK38 (20 mm) naval AAA weapons. Source: https://en.wikipedia.org/wiki/2_cm_Flak_30/38/Flakvierling
-- Used default Mark 15 CIWS Phalanx Block 1 weapon system as template with alterations
GT_t.WS_t.ship_FlaK38 = {name = "2 cm FlaK 38"};
GT_t.WS_t.ship_FlaK38.angles = {
                    {math.rad(180), math.rad(-180), math.rad(-12), math.rad(90)},
                    };
GT_t.WS_t.ship_FlaK38.omegaY = math.rad(115) -- Block 1B
GT_t.WS_t.ship_FlaK38.omegaZ = math.rad(116) -- Block 1B
GT_t.WS_t.ship_FlaK38.pidY = {p=300, i = 0.05, d = 10.0, inn = 1000};
GT_t.WS_t.ship_FlaK38.pidZ = {p=300, i = 0.05, d = 10.0, inn = 1000};
GT_t.WS_t.ship_FlaK38.reference_angle_Z = 0
GT_t.WS_t.ship_FlaK38.LN = {}
GT_t.WS_t.ship_FlaK38.LN[1] = {}
GT_t.WS_t.ship_FlaK38.LN[1].type = 3
GT_t.WS_t.ship_FlaK38.LN[1].distanceMin = 10
GT_t.WS_t.ship_FlaK38.LN[1].distanceMax = 1500 -- effective shooting with 3600 meters
GT_t.WS_t.ship_FlaK38.LN[1].max_trg_alt = 1000
GT_t.WS_t.ship_FlaK38.LN[1].reactionTime = 1.8
GT_t.WS_t.ship_FlaK38.LN[1].beamWidth = math.rad(1);
GT_t.WS_t.ship_FlaK38.LN[1].sensor = {}
set_recursive_metatable(GT_t.WS_t.ship_FlaK38.LN[1].sensor, GT_t.WSN_t[3])
GT_t.WS_t.ship_FlaK38.LN[1].PL = {}
GT_t.WS_t.ship_FlaK38.LN[1].PL[1] = {}
GT_t.WS_t.ship_FlaK38.LN[1].PL[1].ammo_capacity = 1550;
GT_t.WS_t.ship_FlaK38.LN[1].PL[1].shell_name = {"Rh202_20_AP", "Rh202_20_HE"};
GT_t.WS_t.ship_FlaK38.LN[1].PL[1].shell_display_name = "20mm AP+HE";
GT_t.WS_t.ship_FlaK38.LN[1].PL[1].shot_delay = 60/800 -- 3000rpm for Block 0, 4500rpm for Block 1
GT_t.WS_t.ship_FlaK38.LN[1].PL[1].reload_time = 1000000; -- never during the mission (ship autogun)
GT_t.WS_t.ship_FlaK38.LN[1].BR = { {pos = {3.478, 0, 0} }, }



-------------------------------------------------------------------------------------------------
--   Descrizione Cannoni da 105mm
-------------------------------------------------------------------------------------------------

-- SK_C_33 (105 mm) naval artillery weapons. Source: https://en.wikipedia.org/wiki/10.5_cm_FlaK_38
-- Used default Mark 15 CIWS Phalanx Block 1 weapon system as template with alterations
GT_t.WS_t.ship_SK_C_33 = {name = "10.5 cm FlaK 38"};
GT_t.WS_t.ship_SK_C_33.angles = {
                    {math.rad(180), math.rad(-180), math.rad(-3), math.rad(85)},
                    };
GT_t.WS_t.ship_SK_C_33.omegaY = math.rad(115) -- Block 1B
GT_t.WS_t.ship_SK_C_33.omegaZ = math.rad(116) -- Block 1B
GT_t.WS_t.ship_SK_C_33.pidY = {p=300, i = 0.05, d = 10.0, inn = 1000};
GT_t.WS_t.ship_SK_C_33.pidZ = {p=300, i = 0.05, d = 10.0, inn = 1000};
GT_t.WS_t.ship_SK_C_33.reference_angle_Z = 0
GT_t.WS_t.ship_SK_C_33.LN = {}
GT_t.WS_t.ship_SK_C_33.LN[1] = {}
GT_t.WS_t.ship_SK_C_33.LN[1].type = 3
GT_t.WS_t.ship_SK_C_33.LN[1].distanceMin = 0   -----  by baco30,     was 10
GT_t.WS_t.ship_SK_C_33.LN[1].distanceMax = 0 -- effective shooting       1500
GT_t.WS_t.ship_SK_C_33.LN[1].max_trg_alt = 0 -- effective shooting       1000
GT_t.WS_t.ship_SK_C_33.LN[1].reactionTime = 3
GT_t.WS_t.ship_SK_C_33.LN[1].beamWidth = math.rad(1);
GT_t.WS_t.ship_SK_C_33.LN[1].sensor = {}
set_recursive_metatable(GT_t.WS_t.ship_SK_C_33.LN[1].sensor, GT_t.WSN_t[3])
GT_t.WS_t.ship_SK_C_33.LN[1].PL = {}
GT_t.WS_t.ship_SK_C_33.LN[1].PL[1] = {}
GT_t.WS_t.ship_SK_C_33.LN[1].PL[1].ammo_capacity = 0; -- Currently uses same ammo count as SK_C_38  ----  edited baco30 was 240
GT_t.WS_t.ship_SK_C_33.LN[1].PL[1].shell_name = {"SK_C_33_105_HE"};
GT_t.WS_t.ship_SK_C_33.LN[1].PL[1].shell_display_name = "105mm HE";
GT_t.WS_t.ship_SK_C_33.LN[1].PL[1].shot_delay = 60/16.5; -- (16.5 rounds per minute per barrel - average)
GT_t.WS_t.ship_SK_C_33.LN[1].PL[1].reload_time = 1000000; -- never during the mission (ship autogun)
GT_t.WS_t.ship_SK_C_33.LN[1].PL[1].automaticLoader = false;
---GT_t.WS_t.ship_SK_C_33.LN[1].BR = { {pos = {3.478, 0, 0} }, }
---GT_t.WS_t.ship_SK_C_33.LN[1].BR = { {pos = {3.478, 0, 0} }, {pos = {3.478, 0, 0, 0, -0} } }
GT_t.WS_t.ship_SK_C_33.LN[1].BR = { {pos = {8, 0, 0.1} }, {pos = {8, 0, -0.1} } }

-------------------------------------------------------------------------------------------------
--   Descrizione Cannoni da 150mm
-------------------------------------------------------------------------------------------------
-- SK_C_28 (150 mm) naval artillery weapons. Source: https://en.wikipedia.org/wiki/15_cm_SK_C/28
-- Used default FMC5 MK45 127mm Navy artillery weapon system as template with alterations
GT_t.WS_t.ship_SK_C_28 = {name = "15 cm SK C/28"}
GT_t.WS_t.ship_SK_C_28.angles = {
					{math.rad(135), math.rad(-135), math.rad(-10), math.rad(40)},
					};
GT_t.WS_t.ship_SK_C_28.omegaY = 0.6
GT_t.WS_t.ship_SK_C_28.omegaZ = 0.6
GT_t.WS_t.ship_SK_C_28.reference_angle_Z = 0
GT_t.WS_t.ship_SK_C_28.LN = {}
GT_t.WS_t.ship_SK_C_28.LN[1] = {}
GT_t.WS_t.ship_SK_C_28.LN[1].type = 6
GT_t.WS_t.ship_SK_C_28.LN[1].xc = 3
GT_t.WS_t.ship_SK_C_28.LN[1].distanceMin = 0
GT_t.WS_t.ship_SK_C_28.LN[1].max_trg_alt = 0
GT_t.WS_t.ship_SK_C_28.LN[1].reactionTime = 15
GT_t.WS_t.ship_SK_C_28.LN[1].sensor = {}
set_recursive_metatable(GT_t.WS_t.ship_SK_C_28.LN[1].sensor, GT_t.WSN_t[10])
GT_t.WS_t.ship_SK_C_28.LN[1].PL = {}
GT_t.WS_t.ship_SK_C_28.LN[1].PL[1] = {}
GT_t.WS_t.ship_SK_C_28.LN[1].PL[1].ammo_capacity = 0 -- Currently uses same ammo count as SK_C_38			----  edited baco30 was 240
GT_t.WS_t.ship_SK_C_28.LN[1].PL[1].shell_name = {"MK45_127"}; -- Currently uses MK45 127 mm shells (150 mm ammo is WIP)
GT_t.WS_t.ship_SK_C_28.LN[1].PL[1].shot_delay = 60/7.5 -- (7.5 rounds per minute per barrel - average)
GT_t.WS_t.ship_SK_C_28.LN[1].automaticLoader = false;
GT_t.WS_t.ship_SK_C_28.LN[1].reload_time = 240 * 20
GT_t.WS_t.ship_SK_C_28.LN[1].BR = { {pos = {8, 0, 0.1} }, {pos = {8, 0, -0.1} } }


-------------------------------------------------------------------------------------------------
--   Descrizione Cannoni da 380mm
-------------------------------------------------------------------------------------------------
-- SK_C_34 (380 mm) naval artillery weapons. Source: https://en.wikipedia.org/wiki/38_cm_SK_C/34_naval_gun
-- Used default AK130 130mm Navy artillery weapon system as template with alterations
GT_t.WS_t.ship_SK_C_34 = {name = "38 cm SK C/34"}
GT_t.WS_t.ship_SK_C_34.angles = {
					{math.rad(140), math.rad(-140), math.rad(-5.5), math.rad(30)},
					};
GT_t.WS_t.ship_SK_C_34.omegaY = 0.6
GT_t.WS_t.ship_SK_C_34.omegaZ = 0.6
GT_t.WS_t.ship_SK_C_34.reference_angle_Z = 0
GT_t.WS_t.ship_SK_C_34.LN = {}
GT_t.WS_t.ship_SK_C_34.LN[1] = {}
GT_t.WS_t.ship_SK_C_34.LN[1].type = 6
GT_t.WS_t.ship_SK_C_34.LN[1].distanceMin = 50
GT_t.WS_t.ship_SK_C_34.LN[1].max_trg_alt = 20
GT_t.WS_t.ship_SK_C_34.LN[1].reactionTime = 15
GT_t.WS_t.ship_SK_C_34.LN[1].sensor = {}
set_recursive_metatable(GT_t.WS_t.ship_SK_C_34.LN[1].sensor, GT_t.WSN_t[10])
GT_t.WS_t.ship_SK_C_34.LN[1].PL = {}
GT_t.WS_t.ship_SK_C_34.LN[1].PL[1] = {}
GT_t.WS_t.ship_SK_C_34.LN[1].PL[1].ammo_capacity = 0  ----  edited baco30 was 240
GT_t.WS_t.ship_SK_C_34.LN[1].PL[1].shell_name = {"A222_130"}; -- Currently uses A222 130 mm shells (380 mm ammo is WIP)
---GT_t.WS_t.ship_SK_C_34.LN[1].PL[1].shell_name = {"Shell_380mm"};

GT_t.WS_t.ship_SK_C_34.LN[1].PL[1].shot_delay = 60/2.5 -- (2.5 rounds per minute per barrel - average)
GT_t.WS_t.ship_SK_C_34.LN[1].automaticLoader = false;
GT_t.WS_t.ship_SK_C_34.LN[1].reload_time = 240 * 20
GT_t.WS_t.ship_SK_C_34.LN[1].BR = { {pos = {8, 0, 0.1} }, {pos = {8, 0, -0.1} } }

-- weapon systems
GT.WS = {}
local ws;
GT.WS.maxTargetDetectionRange = 450000;
GT.WS.radar_type = 102


-------------------------------------------------------------------------------
-- C:\Program Files\Eagle Dynamics\DCS World OpenBeta\Sounds\Sounders\GroundUnits\WeaponSystem\Navy
-------------------------------------------------------------------------------
-------------------------------------------------------------------------------
--     6  quadruple machine  - side ship bow  ------  Lato poppa    -----------
-------------------------------------------------------------------------------
--- Mitragliatrice quadrinata di Sx 1 - quadruple machine gun left --------------

--1
ws = GT_t.inc_ws();
GT.WS[ws] = {}
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_FlaK38 )
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Breda_37_54 )
GT.WS[ws].area = 'Zona_Fumaiolo'
GT.WS[ws].center = 'CENTER_TOWER_12'
GT.WS[ws].drawArgument1 = 51
GT.WS[ws].drawArgument2 = 52
GT.WS[ws].angles[1][1] = math.rad(135);
GT.WS[ws].angles[1][2] = math.rad(3);
GT.WS[ws].reference_angle_Y = math.rad(0);  -- valore originale 90
GT.WS[ws].LN[1].fireAnimationArgument = -90;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Bsk_MQ_1_01',
--		recoilArgument = 127,
	},
	{
		connector_name = 'POINT_Bsk_MQ_1_02',
--		recoilArgument = 127,
	},
		{
		connector_name = 'POINT_Bsk_MQ_1_03',
--		recoilArgument = 127,
	},
	{
		connector_name = 'POINT_Bsk_MQ_1_04',
--		recoilArgument = 127,
	}
}

--2
ws = GT_t.inc_ws();
GT.WS[ws] = {}
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_FlaK38 )
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Breda_37_54 )
GT.WS[ws].area = 'Zona_Fumaiolo'
GT.WS[ws].center = 'CENTER_TOWER_14'
GT.WS[ws].drawArgument1 = 53
GT.WS[ws].drawArgument2 = 54
GT.WS[ws].angles[1][1] = math.rad(-3);
GT.WS[ws].angles[1][2] = math.rad(-135);
GT.WS[ws].reference_angle_Y = math.rad(-35);  
GT.WS[ws].LN[1].fireAnimationArgument = -90;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Bsk_MQ_2_01',
--		recoilArgument = 129,
	},
	{
		connector_name = 'POINT_Bsk_MQ_2_02',
--		recoilArgument = 129,
	},
		{
		connector_name = 'POINT_Bsk_MQ_2_03',
--		recoilArgument = 129,
	},
	{
		connector_name = 'POINT_Bsk_MQ_2_04',
--		recoilArgument = 129,
	}
}

--3
ws = GT_t.inc_ws();
GT.WS[ws] = {}
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_FlaK38 )
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Breda_37_54 )
GT.WS[ws].area = 'Zona_Fumaiolo'
GT.WS[ws].center = 'CENTER_TOWER_15'
GT.WS[ws].drawArgument1 = 55
GT.WS[ws].drawArgument2 = 56
GT.WS[ws].angles[1][1] = math.rad(135);
GT.WS[ws].angles[1][2] = math.rad(0);
GT.WS[ws].reference_angle_Y = math.rad(90);  
GT.WS[ws].LN[1].fireAnimationArgument = -90;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Bsk_MQ_3_01',
--		recoilArgument = 130,
	},
	{
		connector_name = 'POINT_Bsk_MQ_3_02',
--		recoilArgument = 130,
	},
		{
		connector_name = 'POINT_Bsk_MQ_3_03',
--		recoilArgument = 130,
	},
	{
		connector_name = 'POINT_Bsk_MQ_3_04',
--		recoilArgument = 130,
	}
}

--4
ws = GT_t.inc_ws();
GT.WS[ws] = {}
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_FlaK38 )
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Breda_37_54 )
GT.WS[ws].area = 'Zona_Fumaiolo'
GT.WS[ws].center = 'CENTER_TOWER_16'
GT.WS[ws].drawArgument1 = 57
GT.WS[ws].drawArgument2 = 58
GT.WS[ws].angles[1][1] = math.rad(35);
GT.WS[ws].angles[1][2] = math.rad(-180);
GT.WS[ws].reference_angle_Y = math.rad(-135);  
GT.WS[ws].LN[1].fireAnimationArgument = -90;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Bsk_MQ_4_01',
--		recoilArgument = 131,
	},
	{
		connector_name = 'POINT_Bsk_MQ_4_02',
--		recoilArgument = 131,
	},
		{
		connector_name = 'POINT_Bsk_MQ_4_03',
--		recoilArgument = 131,
	},
	{
		connector_name = 'POINT_Bsk_MQ_4_04',
--		recoilArgument = 131,
	}
}

--5
ws = GT_t.inc_ws();
GT.WS[ws] = {}
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_FlaK38 )
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Breda_37_54 )
GT.WS[ws].area = 'Sala_Comando'
GT.WS[ws].center = 'CENTER_TOWER_17'
GT.WS[ws].drawArgument1 = 59
GT.WS[ws].drawArgument2 = 60
GT.WS[ws].angles[1][1] = math.rad(135);
GT.WS[ws].angles[1][2] = math.rad(-135);
GT.WS[ws].reference_angle_Y = math.rad(-180);  
GT.WS[ws].LN[1].fireAnimationArgument = -90;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Bsk_MQ_5_01',
--		recoilArgument = 132,
	},
	{
		connector_name = 'POINT_Bsk_MQ_5_02',
--		recoilArgument = 132,
	},
		{
		connector_name = 'POINT_Bsk_MQ_5_03',
--		recoilArgument = 132,
	},
	{
		connector_name = 'POINT_Bsk_MQ_5_04',
--		recoilArgument = 132,
	}
}

--6
ws = GT_t.inc_ws();
GT.WS[ws] = {}
--set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_FlaK38 )
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Breda_37_54 )
GT.WS[ws].area = 'Sala_Comando'
GT.WS[ws].center = 'CENTER_TOWER_17'
GT.WS[ws].drawArgument1 = 161
GT.WS[ws].drawArgument2 = 162
GT.WS[ws].angles[1][1] = math.rad(-0);
GT.WS[ws].angles[1][2] = math.rad(-135);
GT.WS[ws].reference_angle_Y = math.rad(-90);  
GT.WS[ws].LN[1].fireAnimationArgument = -90;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Bsk_MQ_6_01',
--		recoilArgument = 132,
	},
	{
		connector_name = 'POINT_Bsk_MQ_6_02',
--		recoilArgument = 132,
	},
		{
		connector_name = 'POINT_Bsk_MQ_6_03',
--		recoilArgument = 132,
	},
	{
		connector_name = 'POINT_Bsk_MQ_6_04',
--		recoilArgument = 132,
	}
}


------------------------------------------------------------------------------------------------
--                      4 Torrette dda 380mm                                                  --  
--------------  Torretta Cannone di Prua 1 Anton -----------------------------------------------
------------------------------------------------------------------------------------------------
-- Note: Currently can fire up to about 23 km in range with 130 mm shells from default AK130 weapons system.
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_34 )
GT.WS[ws].area = 'Sala_Comando' --Torre_380_Anton
GT.WS[ws].center = 'CENTER_TOWER_01'
GT.WS[ws].drawArgument1 = 0
GT.WS[ws].drawArgument2 = 1
GT.WS[ws].angles[1][1] = math.rad(140);
GT.WS[ws].angles[1][2] = math.rad(-140);
GT.WS[ws].reference_angle_Y = math.rad(0);	
GT.WS[ws].LN[1].BR[1].recoilTime = 1.5;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_381MM_1_1',
		recoilArgument = 33,
	},
	{
		connector_name = 'POINT_381MM_1_2',
		recoilArgument = 33,
	}
}


-------------------------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------------------
-------------  Torretta Cannone di Prua 2 Bruno -------------------------------------------------------------

-- Note: Currently can fire up to about 23 km in range with 130 mm shells from default AK130 weapons system.
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_34 )
GT.WS[ws].area = 'Sala_Comando'
GT.WS[ws].center = 'CENTER_TOWER_02'
GT.WS[ws].drawArgument1 = 13
GT.WS[ws].drawArgument2 = 14
GT.WS[ws].angles[1][1] = math.rad(140);
GT.WS[ws].angles[1][2] = math.rad(-140);
GT.WS[ws].reference_angle_Y = math.rad(0);
GT.WS[ws].LN[1].BR[1].recoilTime = 1.5;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_381MM_2_1',
		recoilArgument = 34,
	},
	{
		connector_name = 'POINT_381MM_2_2',
		recoilArgument = 34,
	}
}




------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------
--- Torrette di Poppa
--- Torretta Cannone di Poppa 3  Cesar ----------------------------------------------------------------------

-- Note: Currently can fire up to about 23 km in range with 130 mm shells from default AK130 weapons system.
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_34 )
GT.WS[ws].area = 'Ponte_Poppa'
GT.WS[ws].center = 'CENTER_TOWER_03'
GT.WS[ws].drawArgument1 = 15
GT.WS[ws].drawArgument2 = 16
GT.WS[ws].reference_angle_Y = math.rad(-180);
GT.WS[ws].angles[1][1] = math.rad(-45);
GT.WS[ws].angles[1][2] = math.rad(45);
GT.WS[ws].LN[1].BR[1].recoilTime = 1.5;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_381MM_3_1',
		recoilArgument = 35,
	},
	{
		connector_name = 'POINT_381MM_3_2',
		recoilArgument = 35,
	}
}

------------------------------------------------------------------------------------------------------------
--- Torretta Cannone di Poppa 4  Dora ----------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------

-- Note: Currently can fire up to about 23 km in range with 130 mm shells from default AK130 weapons system.
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_34 )
GT.WS[ws].area = 'Ponte_Poppa'
GT.WS[ws].center = 'CENTER_TOWER_04'
GT.WS[ws].drawArgument1 = 17
GT.WS[ws].drawArgument2 = 18
GT.WS[ws].reference_angle_Y = math.rad(-180);
GT.WS[ws].angles[1][1] = math.rad(-45);
GT.WS[ws].angles[1][2] = math.rad(45);
GT.WS[ws].LN[1].BR[1].recoilTime = 1.5;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_381MM_4_1',
		recoilArgument = 35,
	},
	{
		connector_name = 'POINT_381MM_4_2',
		recoilArgument = 35,
	}
}

---------------------------------------------------------------------------------------------------------------------------------
---------- ***************  7 twin turrets by (Torrette Binate da) 10,5mm   ****************------------------------
---------------------------------------------------------------------------------------------------------------------------------
-----------  naval turrets in the direction of the bow
--- Torretta_105_1
-----------------------------------------------------------
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_33 )
GT.WS[ws].area = 'Ponte_Poppa'
GT.WS[ws].center = 'CENTER_TOWER_18'
GT.WS[ws].drawArgument1 = 142
GT.WS[ws].drawArgument2 = 143
GT.WS[ws].angles[1][1] = math.rad(135);
GT.WS[ws].angles[1][2] = math.rad(0);
GT.WS[ws].reference_angle_Y = math.rad(40);   
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Bsk_105_1_1',
		recoilArgument = 123,
	},
	{
		connector_name = 'POINT_Bsk_105_1_2',
		recoilArgument = 123,
	}
}


--- Torretta_105_2
------------------------------------------------------------
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_33 )
GT.WS[ws].area = 'Ponte_Poppa'
GT.WS[ws].center = 'CENTER_TOWER_19'
GT.WS[ws].drawArgument1 = 44
GT.WS[ws].drawArgument2 = 45
GT.WS[ws].angles[1][1] = math.rad(0);
GT.WS[ws].angles[1][2] = math.rad(-135);
GT.WS[ws].reference_angle_Y = math.rad(-40);   
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Bsk_105_2_1',
		recoilArgument = 125,
	},
	{
		connector_name = 'POINT_Bsk_105_2_2',
		recoilArgument = 125,
	}
}


--- Turret Left 3
------------------------------------------------------------
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_33 )
GT.WS[ws].area = 'Zona_Fumaiolo'
GT.WS[ws].center = 'CENTER_TOWER_20'
GT.WS[ws].drawArgument1 = 46
GT.WS[ws].drawArgument2 = 47
GT.WS[ws].angles[1][1] = math.rad(135);
GT.WS[ws].angles[1][2] = math.rad(0);
GT.WS[ws].reference_angle_Y = math.rad(40);   
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Bsk_105_3_1',
		recoilArgument = 126,
	},
	{
		connector_name = 'POINT_Bsk_105_3_2',
		recoilArgument = 126,
	}
}

--- Turret Right 4
------------------------------------------------------------
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_33 )
GT.WS[ws].area = 'Zona_Fumaiolo'
GT.WS[ws].center = 'CENTER_TOWER_21'
GT.WS[ws].drawArgument1 = 48
GT.WS[ws].drawArgument2 = 49
GT.WS[ws].angles[1][1] = math.rad(0);
GT.WS[ws].angles[1][2] = math.rad(-135);
GT.WS[ws].reference_angle_Y = math.rad(-40);   
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Bsk_105_4_1',
		recoilArgument = 127,
	},
	{
		connector_name = 'POINT_Bsk_105_4_2',
		recoilArgument = 127,
	}
}


------ naval turrets in the direction of the stern
--- Turret Left 5 
------------------------------------------------------------
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_33 )
GT.WS[ws].area = 'Zona_Fumaiolo'
GT.WS[ws].center = 'CENTER_TOWER_22'
GT.WS[ws].drawArgument1 = 68
GT.WS[ws].drawArgument2 = 69
GT.WS[ws].angles[1][1] = math.rad(135);
GT.WS[ws].angles[1][2] = math.rad(15);
GT.WS[ws].reference_angle_Y = math.rad(180);   
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Bsk_105_5_1',
		recoilArgument = 128,
	},
	{
		connector_name = 'POINT_Bsk_105_5_2',
		recoilArgument = 128,
	}
}


--- Turret Right 6
--------------------------------------------------------------------------------------------------------------------------------------------------
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_33 )
GT.WS[ws].area = 'Zona_Fumaiolo'
GT.WS[ws].center = 'CENTER_TOWER_23'
GT.WS[ws].drawArgument1 = 62
GT.WS[ws].drawArgument2 = 63
GT.WS[ws].angles[1][1] = math.rad(-15);
GT.WS[ws].angles[1][2] = math.rad(-135);
GT.WS[ws].reference_angle_Y = math.rad(-135);   
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Bsk_105_6_1',
		recoilArgument = 133,
	},
	{
		connector_name = 'POINT_Bsk_105_6_2',
		recoilArgument = 133,
	}
}


----------------------------------------------------------------
--  18 cannoncini a canna singola da 10,5 GT_t.WS_t.ship_SK_C_33
----------------------------------------------------------------
--1
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_33 )
GT.WS[ws].area = 'Sala_Comando'
GT.WS[ws].center = 'CENTER_TOWER_24'
GT.WS[ws].drawArgument1 = 64
GT.WS[ws].drawArgument2 = 65
GT.WS[ws].angles[1][1] = math.rad(135);
GT.WS[ws].angles[1][2] = math.rad(-135);
GT.WS[ws].reference_angle_Y = math.rad(0);   
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Hip_105_1',
		recoilArgument = 134,
	}

}




--2
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_33 )
GT.WS[ws].area = 'Sala_Comando'
GT.WS[ws].center = 'CENTER_TOWER_34'
GT.WS[ws].drawArgument1 = 169
GT.WS[ws].drawArgument2 = 170
GT.WS[ws].angles[1][1] = math.rad(135);
GT.WS[ws].angles[1][2] = math.rad(-135);
GT.WS[ws].reference_angle_Y = math.rad(0);  
GT.WS[ws].LN[1].fireAnimationArgument = -90;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Hip_105_2',
		recoilArgument = 270,
	}
}


--3
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_33 )
GT.WS[ws].area = 'Sala_Comando'
GT.WS[ws].center = 'CENTER_TOWER_35'
GT.WS[ws].drawArgument1 = 171
GT.WS[ws].drawArgument2 = 172
GT.WS[ws].angles[1][1] = math.rad(135);
GT.WS[ws].angles[1][2] = math.rad(0);
GT.WS[ws].reference_angle_Y = math.rad(35);  
GT.WS[ws].LN[1].fireAnimationArgument = -90;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Hip_105_3',
		recoilArgument = 271,
	}
}


--4
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_33 )
GT.WS[ws].area = 'Sala_Comando'
GT.WS[ws].center = 'CENTER_TOWER_36'
GT.WS[ws].drawArgument1 = 173
GT.WS[ws].drawArgument2 = 174
GT.WS[ws].angles[1][1] = math.rad(-0);
GT.WS[ws].angles[1][2] = math.rad(-135);
GT.WS[ws].reference_angle_Y = math.rad(-35);  
GT.WS[ws].LN[1].fireAnimationArgument = -90;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Hip_105_4',
				recoilArgument = 273,
	}
}


--5
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_33 )
GT.WS[ws].area = 'Sala_Comando'
GT.WS[ws].center = 'CENTER_TOWER_37'
GT.WS[ws].drawArgument1 = 175
GT.WS[ws].drawArgument2 = 176
GT.WS[ws].angles[1][1] = math.rad(135);
GT.WS[ws].angles[1][2] = math.rad(0);
GT.WS[ws].reference_angle_Y = math.rad(35);  
GT.WS[ws].LN[1].fireAnimationArgument = -90;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Hip_105_5',
		recoilArgument = 276,
	}
}


--6
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_33 )
GT.WS[ws].area = 'Sala_Comando'
GT.WS[ws].center = 'CENTER_TOWER_38'
GT.WS[ws].drawArgument1 = 177
GT.WS[ws].drawArgument2 = 178
GT.WS[ws].angles[1][1] = math.rad(-0);
GT.WS[ws].angles[1][2] = math.rad(-135);
GT.WS[ws].reference_angle_Y = math.rad(-35);  
GT.WS[ws].LN[1].fireAnimationArgument = -90;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Hip_105_6',
		recoilArgument = 278,
	}
}


--7
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_33 )
GT.WS[ws].area = 'Sala_Comando'
GT.WS[ws].center = 'CENTER_TOWER_39'
GT.WS[ws].drawArgument1 = 179
GT.WS[ws].drawArgument2 = 180
GT.WS[ws].angles[1][1] = math.rad(135);
GT.WS[ws].angles[1][2] = math.rad(35);
GT.WS[ws].reference_angle_Y = math.rad(135);  
GT.WS[ws].LN[1].fireAnimationArgument = -90;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Hip_105_7',
		recoilArgument = 280,
	}
}


--8
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_33 )
GT.WS[ws].area = 'Sala_Comando'
GT.WS[ws].center = 'CENTER_TOWER_40'
GT.WS[ws].drawArgument1 = 181
GT.WS[ws].drawArgument2 = 182
GT.WS[ws].angles[1][1] = math.rad(135);
GT.WS[ws].angles[1][2] = math.rad(0);
GT.WS[ws].reference_angle_Y = math.rad(135);  
GT.WS[ws].LN[1].fireAnimationArgument = -90;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Hip_105_8',
		recoilArgument = 281,
	}
}


--9
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_33 )
GT.WS[ws].area = 'Sala_Comando'
GT.WS[ws].center = 'CENTER_TOWER_41'
GT.WS[ws].drawArgument1 = 183
GT.WS[ws].drawArgument2 = 184
GT.WS[ws].angles[1][1] = math.rad(-0);
GT.WS[ws].angles[1][2] = math.rad(-180);
GT.WS[ws].reference_angle_Y = math.rad(-180);  
GT.WS[ws].LN[1].fireAnimationArgument = -90;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Hip_105_9',
		recoilArgument = 283,
	}
}


--10
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_33 )
GT.WS[ws].area = 'Sala_Comando'
GT.WS[ws].center = 'CENTER_TOWER_42'
GT.WS[ws].drawArgument1 = 185
GT.WS[ws].drawArgument2 = 186
GT.WS[ws].angles[1][1] = math.rad(135);
GT.WS[ws].angles[1][2] = math.rad(0);
GT.WS[ws].reference_angle_Y = math.rad(135);  
GT.WS[ws].LN[1].fireAnimationArgument = -90;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_FlaK38_10',
		recoilArgument = 285,
	}
}


--11
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_33 )
GT.WS[ws].area = 'Sala_Comando'
GT.WS[ws].center = 'CENTER_TOWER_43'
GT.WS[ws].drawArgument1 = 187
GT.WS[ws].drawArgument2 = 188
GT.WS[ws].angles[1][1] = math.rad(135);
GT.WS[ws].angles[1][2] = math.rad(35);
GT.WS[ws].reference_angle_Y = math.rad(135);  
GT.WS[ws].LN[1].fireAnimationArgument = -90;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_FlaK38_11',
		recoilArgument = 287,
	}
}

--12
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_33 )
GT.WS[ws].area = 'Ponte_Poppa'
GT.WS[ws].center = 'CENTER_TOWER_33'
GT.WS[ws].drawArgument1 = 167
GT.WS[ws].drawArgument2 = 168
GT.WS[ws].angles[1][1] = math.rad(-35);
GT.WS[ws].angles[1][2] = math.rad(-135);
GT.WS[ws].reference_angle_Y = math.rad(-135);  
GT.WS[ws].LN[1].fireAnimationArgument = -90;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_FlaK38_12',
		recoilArgument = 268,
	}
}

--13
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_33 )
GT.WS[ws].area = 'Ponte_Poppa'
GT.WS[ws].center = 'CENTER_TOWER_32'
GT.WS[ws].drawArgument1 = 165
GT.WS[ws].drawArgument2 = 166
GT.WS[ws].angles[1][1] = math.rad(-45);
GT.WS[ws].angles[1][2] = math.rad(45);
GT.WS[ws].reference_angle_Y = math.rad(-180);  
GT.WS[ws].LN[1].fireAnimationArgument = -90;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_FlaK38_13',
		recoilArgument = 265,
	}
}


--14
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_33 )
GT.WS[ws].area = 'Ponte_Poppa'
GT.WS[ws].center = 'CENTER_TOWER_26'
GT.WS[ws].drawArgument1 = 153
GT.WS[ws].drawArgument2 = 154
GT.WS[ws].angles[1][1] = math.rad(135);
GT.WS[ws].angles[1][2] = math.rad(0);
GT.WS[ws].reference_angle_Y = math.rad(90);  
GT.WS[ws].LN[1].fireAnimationArgument = -90;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_FlaK38_14',
		recoilArgument = 253,
	}
}


--15
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_33 )
GT.WS[ws].area = 'Ponte_Poppa'
GT.WS[ws].center = 'CENTER_TOWER_27'
GT.WS[ws].drawArgument1 = 155
GT.WS[ws].drawArgument2 = 156
GT.WS[ws].angles[1][1] = math.rad(-0);
GT.WS[ws].angles[1][2] = math.rad(-135);
GT.WS[ws].reference_angle_Y = math.rad(-90);  
GT.WS[ws].LN[1].fireAnimationArgument = -90;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_FlaK38_15',
		recoilArgument = 255,
	}
}


--16
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_33 )
GT.WS[ws].area = 'Zona_Fumaiolo'
GT.WS[ws].center = 'CENTER_TOWER_28'
GT.WS[ws].drawArgument1 = 157
GT.WS[ws].drawArgument2 = 158
GT.WS[ws].angles[1][1] = math.rad(135);
GT.WS[ws].angles[1][2] = math.rad(0);
GT.WS[ws].reference_angle_Y = math.rad(135);  
GT.WS[ws].LN[1].fireAnimationArgument = -90;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_FlaK38_16',
		recoilArgument = 257,
	}
}


--17
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_33 )
GT.WS[ws].area = 'Zona_Fumaiolo'
GT.WS[ws].center = 'CENTER_TOWER_29'
GT.WS[ws].drawArgument1 = 159
GT.WS[ws].drawArgument2 = 160
GT.WS[ws].angles[1][1] = math.rad(-0);
GT.WS[ws].angles[1][2] = math.rad(-135);
GT.WS[ws].reference_angle_Y = math.rad(-135);  
GT.WS[ws].LN[1].fireAnimationArgument = -90;
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_FlaK38_17',
		recoilArgument = 259,
	}
}

--18
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_SK_C_33 )
GT.WS[ws].area = 'Zona_Fumaiolo'
GT.WS[ws].center = 'CENTER_TOWER_25'
GT.WS[ws].drawArgument1 = 66
GT.WS[ws].drawArgument2 = 67
GT.WS[ws].angles[1][1] = math.rad(135);
GT.WS[ws].angles[1][2] = math.rad(-135);
GT.WS[ws].reference_angle_Y = math.rad(0);   
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_FlaK38_18',
		recoilArgument = 266,
	}
	
}


------------------------------------------------------------------------------------------
----------             2 Mitragliatrici Binate     GT_t.WS_t.ship_FlaK38    --------------
---------------------------------------------------------------------------_--------------
--1
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_FlaK38 )
GT.WS[ws].area = 'Zona_Fumaiolo'
GT.WS[ws].center = 'CENTER_TOWER_05'
GT.WS[ws].drawArgument1 = 19
GT.WS[ws].drawArgument2 = 20
GT.WS[ws].angles[1][1] = math.rad(180);
GT.WS[ws].angles[1][2] = math.rad(0);
GT.WS[ws].reference_angle_Y = math.rad(0);   ----- posizione inziale rispetto all'angolo 0 (+ senso antiorario, - senso orario)
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_FlaK38_1_1',
		recoilArgument = 37,
	},
	{
		connector_name = 'POINT_FlaK38_1_2',
		recoilArgument = 37,
	}
}



--2
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_FlaK38 )
GT.WS[ws].area = 'Zona_Fumaiolo'
GT.WS[ws].center = 'CENTER_TOWER_06'
GT.WS[ws].drawArgument1 = 21
GT.WS[ws].drawArgument2 = 22
GT.WS[ws].angles[1][1] = math.rad(-0);
GT.WS[ws].angles[1][2] = math.rad(-180);
GT.WS[ws].reference_angle_Y = math.rad(-0);   ----- posizione inziale rispetto all'angolo 0 (+ senso antiorario, - senso orario)
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_FlaK38_2_1',
		recoilArgument = 38,
	},
	{
		connector_name = 'POINT_FlaK38_2_2',
		recoilArgument = 38,
	}
}

------------------------------------------------------------------------------------------------------
--      Parte Finale                                                                                --
------------------------------------------------------------------------------------------------------
GT.Name = "WS_Blucher"
GT.DisplayName = _("DKM Blucher")
GT.Rate = 6000

GT.Sensors = {  OPTIC = {"long-range naval optics", "long-range naval LLTV", "long-range naval FLIR",},
                RADAR = {
                "Patriot str",
                "ticonderoga search radar",
                }
            };


			
GT.DetectionRange  = GT.airFindDist;
GT.ThreatRange = GT.airWeaponDist;

GT.Singleton   ="no";
GT.mapclasskey = "P0091000067";
GT.attribute = {wsType_Navy,wsType_Ship,wsType_ArmedShip,wsType_GenericLightArmoredShip,

                    "Cruisers",
                    "RADAR_BAND1_FOR_ARM",
                    "DetectionByAWACS",
				};
				



GT.Categories = {
					{name = "Armed Ship"},
				};
---GT.Countries = { "GERMANY", "Germany", "GER",};
add_surface_unit(GT)	
			